package com.ejie.aa17a.service.impl;

import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa17a.dao.iface.Aa17aBandaContaminanteDao;
import com.ejie.aa17a.model.Aa17aBandaContaminante;
import com.ejie.aa17a.service.iface.Aa17aBandaContaminanteService;
import com.ejie.x38.dto.Pagination;

/**
 * Aa17aBandaContaminanteServiceImpl generated by UDA, 18-dic-2013 15:36:14.
 * 
 * @author UDA
 */

public class Aa17aBandaContaminanteServiceImpl implements Aa17aBandaContaminanteService {

	private static final Logger logger = LoggerFactory.getLogger(Aa17aBandaContaminanteServiceImpl.class);

	private Aa17aBandaContaminanteDao aa17aBandaContaminanteDao;

	/**
	 * Inserts a single row in the Aa17aBandaContaminante table.
	 * 
	 * @param aa17aBandaContaminante
	 *            Aa17aBandaContaminante
	 * @return Aa17aBandaContaminante
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Aa17aBandaContaminante add(Aa17aBandaContaminante aa17aBandaContaminante) {
		return this.aa17aBandaContaminanteDao.add(aa17aBandaContaminante);
	}

	/**
	 * Updates a single row in the Aa17aBandaContaminante table.
	 * 
	 * @param aa17aBandaContaminante
	 *            Aa17aBandaContaminante
	 * @return Aa17aBandaContaminante
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Aa17aBandaContaminante update(Aa17aBandaContaminante aa17aBandaContaminante) {
		return this.aa17aBandaContaminanteDao.update(aa17aBandaContaminante);
	}

	/**
	 * Finds a single row in the Aa17aBandaContaminante table.
	 * 
	 * @param aa17aBandaContaminante
	 *            Aa17aBandaContaminante
	 * @return Aa17aBandaContaminante
	 */
	public Aa17aBandaContaminante find(Aa17aBandaContaminante aa17aBandaContaminante) {
		return (Aa17aBandaContaminante) this.aa17aBandaContaminanteDao.find(aa17aBandaContaminante);
	}

	/**
	 * Finds a List of rows in the Aa17aBandaContaminante table.
	 * 
	 * @param aa17aBandaContaminante
	 *            Aa17aBandaContaminante
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Aa17aBandaContaminante> findAll(Aa17aBandaContaminante aa17aBandaContaminante, Pagination pagination) {
		return (List<Aa17aBandaContaminante>) this.aa17aBandaContaminanteDao.findAll(aa17aBandaContaminante, pagination);
	}

	/**
	 * Counts rows in the Aa17aBandaContaminante table.
	 * 
	 * @param aa17aBandaContaminante
	 *            Aa17aBandaContaminante
	 * @return Long
	 */
	public Long findAllCount(Aa17aBandaContaminante aa17aBandaContaminante) {
		return this.aa17aBandaContaminanteDao.findAllCount(aa17aBandaContaminante);
	}

	/**
	 * Finds rows in the Aa17aBandaContaminante table using like.
	 * 
	 * @param aa17aBandaContaminante
	 *            Aa17aBandaContaminante
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Aa17aBandaContaminante> findAllLike(Aa17aBandaContaminante aa17aBandaContaminante, Pagination pagination, Boolean startsWith) {
		return (List<Aa17aBandaContaminante>) this.aa17aBandaContaminanteDao.findAllLike(aa17aBandaContaminante, pagination, startsWith);
	}

	/**
	 * Counts rows in the Aa17aBandaContaminante table using like.
	 * 
	 * @param aa17aBandaContaminante
	 *            Aa17aBandaContaminante
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(Aa17aBandaContaminante aa17aBandaContaminante, Boolean startsWith) {
		return this.aa17aBandaContaminanteDao.findAllLikeCount(aa17aBandaContaminante, startsWith);
	}

	/**
	 * Deletes a single row in the Aa17aBandaContaminante table.
	 * 
	 * @param aa17aBandaContaminante
	 *            Aa17aBandaContaminante
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Aa17aBandaContaminante aa17aBandaContaminante) {
		this.aa17aBandaContaminanteDao.remove(aa17aBandaContaminante);
	}

	/**
	 * Deletes multiple rows in the Aa17aBandaContaminante table.
	 * 
	 * @param aa17aBandaContaminanteList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<Aa17aBandaContaminante> aa17aBandaContaminanteList) {
		for (Aa17aBandaContaminante aa17aBandaContaminanteAux : aa17aBandaContaminanteList) {
			this.aa17aBandaContaminanteDao.remove(aa17aBandaContaminanteAux);
		}
	}

	/**
	 * Setter method for Aa17aBandaContaminanteDao.
	 * 
	 * @param aa17aBandaContaminanteDao
	 *            Aa17aBandaContaminanteDao
	 * @return
	 */
	public void setAa17aBandaContaminanteDao(Aa17aBandaContaminanteDao aa17aBandaContaminanteDao) {
		Aa17aBandaContaminanteServiceImpl.logger.info("Setting Dependency " + aa17aBandaContaminanteDao);
		this.aa17aBandaContaminanteDao = aa17aBandaContaminanteDao;
	}
}
